/*
 * Decompiled with CFR 0.152.
 */
package net.firemuffin303.thaidelight;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;
import net.firemuffin303.thaidelight.common.registry.ModBlocks;
import net.firemuffin303.thaidelight.common.registry.ModConfiguredFeatures;
import net.firemuffin303.thaidelight.common.registry.ModEntityTypes;
import net.firemuffin303.thaidelight.common.registry.ModItems;
import net.firemuffin303.thaidelight.common.registry.ModMenuType;
import net.firemuffin303.thaidelight.common.registry.ModRecipes;
import net.firemuffin303.thaidelight.common.registry.ModSoundEvents;
import net.firemuffin303.thaidelight.common.registry.ModTreeDecorator;
import net.firemuffin303.thaidelight.mixin.ChickenFoodAccessor;
import net.firemuffin303.thaidelight.mixin.FrogFoodAccessor;
import net.firemuffin303.thaidelight.mixin.ParrotTameFoodAccessor;
import net.firemuffin303.thaidelight.mixin.PigFoodAccessor;
import net.firemuffin303.thaidelight.mixin.StructurePoolAccessorMixin;
import net.firemuffin303.thaidelight.utils.ModPlatform;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThaiDelight {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"muffins_thaidelight");
    public static final String MOD_ID = "muffins_thaidelight";

    public static void init() {
        ModEntityTypes.init();
        ModBlocks.init();
        ModItems.init();
        ModRecipes.init();
        ModConfiguredFeatures.init();
        ModRecipes.ModRecipeSerializer.init();
        ModMenuType.init();
        ModSoundEvents.init();
        ModTreeDecorator.init();
    }

    public static void postInit() {
        ModEntityTypes.postInit();
        ThaiDelight.registerComposterBlock();
        ThaiDelight.registerStrippables();
        ThaiDelight.registerAnimalFoodItem();
    }

    public static void registerComposterBlock() {
        ComposterBlock.f_51914_.put((Object)ModItems.PEPPER_SEED, 0.3f);
        ComposterBlock.f_51914_.put((Object)Item.m_41439_((Block)ModBlocks.PAPAYA_LEAVES), 0.3f);
        ComposterBlock.f_51914_.put((Object)Item.m_41439_((Block)ModBlocks.LIME_SAPLING), 0.3f);
        ComposterBlock.f_51914_.put((Object)Item.m_41439_((Block)ModBlocks.PAPAYA_SAPLING), 0.3f);
        ComposterBlock.f_51914_.put((Object)ModItems.PEPPER, 0.65f);
        ComposterBlock.f_51914_.put((Object)ModItems.LIME, 0.65f);
        ComposterBlock.f_51914_.put((Object)ModItems.RAW_PAPAYA, 0.65f);
        ComposterBlock.f_51914_.put((Object)ModItems.PAPAYA, 0.65f);
        ComposterBlock.f_51914_.put((Object)ModItems.SLICED_LIME, 0.4f);
        ComposterBlock.f_51914_.put((Object)ModItems.RAW_PAPAYA_SLICE, 0.4f);
        ComposterBlock.f_51914_.put((Object)ModItems.SLICED_PAPAYA, 0.4f);
        ComposterBlock.f_51914_.put((Object)Item.m_41439_((Block)ModBlocks.PAPAYA_LOG), 0.8f);
        ComposterBlock.f_51914_.put((Object)Item.m_41439_((Block)ModBlocks.STRIPPED_PAPAYA_LOG), 0.8f);
        ComposterBlock.f_51914_.put((Object)Item.m_41439_((Block)ModBlocks.PAPAYA_WOOD), 0.8f);
        ComposterBlock.f_51914_.put((Object)Item.m_41439_((Block)ModBlocks.STRIPPED_PAPAYA_WOOD), 0.8f);
    }

    public static void registerStrippables() {
        HashMap<Block, Block> stippables = new HashMap<Block, Block>();
        stippables.put(ModBlocks.PAPAYA_LOG, ModBlocks.STRIPPED_PAPAYA_LOG);
        stippables.put(ModBlocks.PAPAYA_WOOD, ModBlocks.STRIPPED_PAPAYA_WOOD);
        ModPlatform.registerStrippables(stippables);
    }

    public static void registerAnimalFoodItem() {
        ParrotTameFoodAccessor.getTameFood().add(Item.m_41439_((Block)ModBlocks.PAPAYA_SAPLING));
        ParrotTameFoodAccessor.getTameFood().add(ModItems.PEPPER_SEED);
        Ingredient newPigFoods = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.RAW_PAPAYA, ModItems.PAPAYA, ModItems.SLICED_PAPAYA, ModItems.RAW_PAPAYA_SLICE, ModItems.LIME, ModItems.SLICED_LIME});
        Ingredient newChickenFoods = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.PAPAYA_SEEDS, ModItems.PEPPER_SEED});
        Ingredient newFrogFoods = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.DRAGONFLY, ModItems.COOKED_DRAGONFLY});
        PigFoodAccessor.setFoodItems(Ingredient.m_43921_((Stream)new ImmutableList.Builder().addAll(Arrays.stream(PigFoodAccessor.getFoodItems().m_43908_()).iterator()).addAll(Arrays.asList(newPigFoods.m_43908_())).build().stream()));
        ChickenFoodAccessor.setFoodItems(Ingredient.m_43921_((Stream)new ImmutableList.Builder().addAll(Arrays.stream(ChickenFoodAccessor.getFoodItems().m_43908_()).iterator()).addAll(Arrays.asList(newChickenFoods.m_43908_())).build().stream()));
        FrogFoodAccessor.setFoodItems(Ingredient.m_43921_((Stream)new ImmutableList.Builder().addAll(Arrays.asList(FrogFoodAccessor.getFoodItems().m_43908_()).iterator()).addAll(Arrays.asList(newFrogFoods.m_43908_())).build().stream()));
    }

    public static void registerStructure(MinecraftServer server) {
        ThaiDelight.addToStructurePool(server, new ResourceLocation("minecraft", "village/plains/houses"), new ResourceLocation(MOD_ID, "village/plains/houses/small_thai_house_1"), 4);
        ThaiDelight.addToStructurePool(server, new ResourceLocation("minecraft", "village/savanna/houses"), new ResourceLocation(MOD_ID, "village/savanna/houses/savanna_small_thai_house_1"), 4);
    }

    public static void addToStructurePool(MinecraftServer server, ResourceLocation poolIdentifier, ResourceLocation nbtIdentifier, int weight) {
        Holder.Reference emptyProcessList = server.m_206579_().m_175515_(Registries.f_257011_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("minecraft", "empty")));
        Registry structureTemplatePools = (Registry)server.m_206579_().m_6632_(Registries.f_256948_).orElseThrow();
        StructureTemplatePool structure = (StructureTemplatePool)structureTemplatePools.m_7745_(poolIdentifier);
        if (structure == null) {
            return;
        }
        SinglePoolElement singlePoolElement = (SinglePoolElement)StructurePoolElement.m_210512_((String)nbtIdentifier.toString(), (Holder)emptyProcessList).apply(StructureTemplatePool.Projection.RIGID);
        ArrayList<Pair<StructurePoolElement, Integer>> elements = new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessorMixin)structure).getRawTemplates());
        elements.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)singlePoolElement, (Object)weight));
        ((StructurePoolAccessorMixin)structure).setRawTemplates(elements);
        for (int i = 0; i < weight; ++i) {
            ((StructurePoolAccessorMixin)structure).getTemplates().add((Object)singlePoolElement);
        }
    }
}

